package main

import (
	"bytes"
	"fmt"
	"fss_demo/auth"
	"io"
	"log"
	"net/http"
	"os"
	"strconv"
	"sync"
	"time"
)

const (
	BaseUrl        = "服务URL"
	BucketName     = "服务名"
	BucketPassword = "服务密码"
)

// 认证类型
var authType = auth.SignAuth
/**
Demo 演示，不做异常处理
 */
func main() {
	// region 获取目录文件列表
	listFolderAndFile()
	// endregion

	// region 获取文件信息
	//info()
	// endregion


	// region 创建目录
	//createPath()
	// endregion


	// region 删除目录
	//removePath()
	// endregion

	// region 删除文件
	//removeFile()
	// endregion

	// region 文件上传
	//uploadFile()
	// endregion


	// region 复制文件
	//copyFile()
	// endregion


	// region 移动文件
	//moveFile()
	// endregion

	// region 下载文件
	//download()
	// endregion

	// region 修改 MetaData
	//modifyMeta()
	// endregion

	// region 文件分块上传
	// 单线程分块上传
	//uploadFileChunked()
	// endregion

}
// 获取目录文件列表
func listFolderAndFile()  {
	folderPath := "/myfile"
	folderPath = url.QueryEscape(folderPath)
	uri := fmt.Sprintf("/%s%s", BucketName, folderPath)
	method := http.MethodGet
	contentMd5 := ""

    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	param := map[string]string{
		//"x-list-limit":"1",
		"x-list-order":"desc",
	}
	newUtils.createRequest(nil).setParam(param).printResult()
}

// 获取文件信息
func info()  {
	file := "/myfile/copy_from_new_test_upload4.txt"
	file = url.QueryEscape(file)
	uri := fmt.Sprintf("/%s%s", BucketName, file)
	method := http.MethodHead
	contentMd5 := ""

    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)
	// 这里注意提取自己需要的响应头
	newUtils.createRequest(nil).printResult()
}

// 创建目录
func createPath()  {
	newPath := "/myfile"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodPost
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	param := map[string]string{
		"folder": "true",
	}
	newUtils.createRequest(nil).setParam(param).printResult()
}

// 删除目录
func removePath()  {
	newPath := "/myfile"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodDelete
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	newUtils.createRequest(nil).printResult()
}

// 删除文件
func removeFile()  {
	newPath := "/myfile/big2.pdf"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodDelete
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	param := map[string]string{
		"x-west-async": "false",
	}
	newUtils.createRequest(nil).setParam(param).printResult()
}

// 复制文件
func copyFile()  {
	newPath := "/myfile/copy_from_new_test_upload4.txt"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodPut
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	sourceFile := "/myfile/new_test_upload3.txt"
	param := map[string]string{
		"x-west-copy-source": fmt.Sprintf("/%s%s", BucketName, sourceFile),
	}
	newUtils.createRequest(nil).setParam(param).printResult()
}

// 修改 MetaData
func modifyMeta()  {
	newPath := "/myfile/copy_from_new_test_upload4.txt"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodPatch
	contentMd5 := ""
    var date = time.Now()
	uri += "?metadata=merge"
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	param := map[string]string{
		"x-west-meta-mykey": "my_value",
	}

	newUtils.createRequest(nil).setParam(param).printResult()
}

//  移动文件
func moveFile()  {
	newPath := "/myfile/move_from_new_test_upload.txt"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodPut
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	sourceFile := "/myfile/new_test_upload.txt"
	param := map[string]string{
		"x-west-move-source": fmt.Sprintf("/%s%s", BucketName, sourceFile),
	}
	newUtils.createRequest(nil).setParam(param).printResult()
}

// 下载文件
func download()  {
	newPath := "/myfile/move_from_new_test_upload.txt"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodGet
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	// 需自行设置header
	newUtils.createRequest(nil).printResult()
}

//  文件上传
func uploadFile()  {
	newPath := "/myfile/new_test_upload5.txt"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodPut
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	// 要上传的文件
	localFile := "待上传的文件"
	file, err := os.Open(localFile)
	if err != nil{
		log.Fatalln(err)
	}
	stat, err := file.Stat()
	if err != nil{
		log.Fatalln(err)
	}

	length := strconv.FormatInt(stat.Size(),10)
	param := map[string]string{
		"Content-Length": length,
	}

	newUtils.createRequest(file).setParam(param).printResult()
}



// 分片上传，串行
func uploadFileChunked()  {
	newPath := "/path/filename"
	newPath = url.QueryEscape(newPath)
	uri := fmt.Sprintf("/%s%s", BucketName, newPath)
	method := http.MethodPut
	contentMd5 := ""
    var date = time.Now()
	authHandler := auth.NewAuthorize(uri, contentMd5, BucketName, BucketPassword, method, date, authType)
	newUtils := newUtils(BaseUrl, authHandler)

	// 要上传的文件
	localFile := "待上传的文件"
	file, err := os.Open(localFile)
	if err != nil{
		log.Fatalln(err)
	}
	stat, err := file.Stat()
	if err != nil{
		log.Fatalln(err)
	}

	totalLength := strconv.FormatInt(stat.Size(),10)
	// 1. 初始化
	param := map[string]string{
		"x-west-multi-disorder":"true",
		"x-west-multi-stage":"initiate",
		"x-west-multi-length":totalLength,
	}
	newUtils.createRequest(nil).setParam(param).printResult()
	// 这里需要判断是否初始化成功，成功后再继续下一步


	// 注意：分片必须为 1MB
	maxChunkSize := 1024* 1024


	var num int64 = 0
	for  {
		buf := make([]byte, maxChunkSize)
		n, err := file.Read(buf)
        if err != nil && err != io.EOF{
            log.Fatalln(err)
        }
        if 0 == n{
            break
        }

		// 2. 正式上传，多次
		param = map[string]string{
			"x-west-multi-disorder":"true",
			"x-west-multi-stage":"upload",
			"x-west-part-id":strconv.FormatInt(num, 10),
		}

		newUtils.createRequest(bytes.NewReader(buf)).setParam(param).printResult()
		fmt.Printf("第 %d 片完成\n", num)
		num++
	}

	// 3. 完成上传
	param = map[string]string{
		"x-west-multi-disorder":"true",
		"x-west-multi-stage":"complete",
	}

	newUtils.createRequest(nil).setParam(param).printResult()
}
